<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos;

use JsonSerializable;
use Erlage\Photogram\Reflection\TraitReflectionAbstractClassName;

abstract class AbstractDTO implements JsonSerializable
{
    use TraitReflectionAbstractClassName;

    /**
     * @param object $data  
     */
    abstract public static function validate($data): string;

    /**
     * @return static 
     */
    abstract public static function transform($data);

    /**
     * @param object $data 
     */
    abstract public static function serialize($data): string;

    /**
     * @return static 
     */
    abstract public static function deSerialize(string $data);

    public static function serializer(): array
    {
        return array(self::erlClass(), 'serialize');
    }

    public static function deSerializer(): array
    {
        return array(self::erlClass(), 'deSerialize');
    }

    /*
    |--------------------------------------------------------------------------
    | note that we are adding business logic into DTOs.
    | it exists only on server side, the reason being DTOs are used on all rich
    | content attributes in this app therefore it makes more sense to place
    | validation logic alongside of data that's being validated
    |--------------------------------------------------------------------------
    */

    public static function transformer(): array
    {
        return array(self::erlClass(), 'transform');
    }

    public static function validator(): array
    {
        return array(self::erlClass(), 'validate');
    }
}
